/**
 * AtoShip Orders Scripts
 *
 * @package AtoShip
 */

(function($) {
    'use strict';

    var AtoShipOrders = {
        init: function() {
            this.bindEvents();
        },

        bindEvents: function() {
            // Single order sync button
            $(document).on('click', '.atoship-sync-btn', this.syncOrder);
        },

        syncOrder: function(e) {
            e.preventDefault();

            var $btn = $(this);
            var orderId = $btn.data('order-id');
            var originalText = $btn.text();

            $btn.prop('disabled', true).text(atoshipOrders.i18n.syncing);

            $.ajax({
                url: atoshipOrders.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'atoship_sync_order',
                    order_id: orderId,
                    nonce: atoshipOrders.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $btn.text(atoshipOrders.i18n.synced);
                        // Reload the page to show updated meta box
                        setTimeout(function() {
                            location.reload();
                        }, 1000);
                    } else {
                        alert(response.data.message || atoshipOrders.i18n.error);
                        $btn.prop('disabled', false).text(originalText);
                    }
                },
                error: function() {
                    alert(atoshipOrders.i18n.error);
                    $btn.prop('disabled', false).text(originalText);
                }
            });
        }
    };

    $(document).ready(function() {
        AtoShipOrders.init();
    });

})(jQuery);
